<?php
// bot.php – ربات تلگرام با webhook و امکانات کامل مدیریت تست VPN

require_once "functions.php";

$botToken = "YOUR_BOT_TOKEN_HERE"; // توکن ربات تلگرام شما
$channelUsername = "vpnglobale";
$adminId = 5527480221;

$content = file_get_contents("php://input");
$update = json_decode($content, true);

if (!$update || !isset($update['message'])) exit;

$message = $update['message'];
$chatId = $message['chat']['id'];
$userId = $message['from']['id'];
$username = $message['from']['username'] ?? '';
$text = trim($message['text'] ?? '');

if ($text === "/start") {
    sendMessage($chatId, "سلام خوش آمدید 
برای دریافت اکانت تست لطفاً از دکمه‌ها استفاده کنید.", [
        ['دریافت اکانت تست'],
        ['ارسال پیام به پشتیبانی'],
        [
            ['text' => 'خرید سرویس', 'url' => 'https://t.me/yourMainBot'],
            ['text' => 'عضو کانال شو', 'url' => 'https://t.me/vpnglobale']
        ]
    ]);
    exit;
}

if ($text === "دریافت اکانت تست") {
    if (!isUserInChannel($userId, $channelUsername, $botToken)) {
        sendMessage($chatId, "🚫 لطفاً نخست در کانال @vpnglobale عضو شوید.");
        exit;
    }

    if (isUserBlocked($userId)) {
        sendMessage($chatId, "این گزینه برای شما غیرفعال شده");
        exit;
    }

    $limitCheck = checkUserTestLimits($userId);
    if ($limitCheck !== true) {
        sendMessage($chatId, $limitCheck);
        exit;
    }

    $remark = "test_" . $userId;
    $result = createTestAccount($remark);

    if (strpos($result, 'vmess') !== false || strpos($result, 'vless') !== false || strpos($result, 'trojan') !== false) {
        sendMessage($chatId, "اکانت شما ساخته شد:
$result");
        sendQRCode($chatId, $result);
        notifyAdmin($adminId, $userId, $username);
        registerTest($userId);
    } else {
        sendMessage($chatId, "خطا در ساخت اکانت. مجدداً تلاش کنید.");
    }
    exit;
}

if ($text === "ارسال پیام به پشتیبانی") {
    sendMessage($chatId, "مشکلتون رو ارسال کنید. تکنسین پشتیبان پشت سر شماست.");
    exit;
}

if (preg_match("/^\/set(protocol|server|inbound|gb|days) (.+)/", $text, $matches) && $userId == $adminId) {
    $key = $matches[1];
    $value = $matches[2];
    setConfig($key, $value);
    sendMessage($chatId, "تنظیم '$key' با مقدار '$value' ثبت شد.");
    exit;
}

if ($text === "/status" && $userId == $adminId) {
    $stats = getTestStats();
    sendMessage($chatId, $stats);
    exit;
}

sendMessage($chatId, "دستور نامعروف")
?>